/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory.item;

import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum BedrockEnchantment {
    PROTECTION,
    FIRE_PROTECTION,
    FEATHER_FALLING,
    BLAST_PROTECTION,
    PROJECTILE_PROTECTION,
    THORNS,
    RESPIRATION,
    DEPTH_STRIDER,
    AQUA_AFFINITY,
    SHARPNESS,
    SMITE,
    BANE_OF_ARTHROPODS,
    KNOCKBACK,
    FIRE_ASPECT,
    LOOTING,
    EFFICIENCY,
    SILK_TOUCH,
    UNBREAKING,
    FORTUNE,
    POWER,
    PUNCH,
    FLAME,
    INFINITY,
    LUCK_OF_THE_SEA,
    LURE,
    FROST_WALKER,
    MENDING,
    BINDING_CURSE,
    VANISHING_CURSE,
    IMPALING,
    RIPTIDE,
    LOYALTY,
    CHANNELING,
    MULTISHOT,
    PIERCING,
    QUICK_CHARGE,
    SOUL_SPEED,
    SWIFT_SNEAK,
    WIND_BURST,
    DENSITY,
    BREACH;

    private static final BedrockEnchantment[] VALUES;
    private final String javaIdentifier = "minecraft:" + this.name().toLowerCase(Locale.ENGLISH);

    public static @Nullable BedrockEnchantment getByJavaIdentifier(String javaIdentifier) {
        for (BedrockEnchantment enchantment : VALUES) {
            if (!enchantment.javaIdentifier.equals(javaIdentifier) && !enchantment.name().toLowerCase(Locale.ENGLISH).equalsIgnoreCase(javaIdentifier)) continue;
            return enchantment;
        }
        return null;
    }

    public static @Nullable BedrockEnchantment getByBedrockId(int bedrockId) {
        if (bedrockId >= 0 && bedrockId < VALUES.length) {
            return VALUES[bedrockId];
        }
        return null;
    }

    static {
        VALUES = BedrockEnchantment.values();
    }
}

