/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory.item;

import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.key.Key;
import org.geysermc.geyser.util.MinecraftKey;

public enum BannerPattern {
    BASE("b"),
    SQUARE_BOTTOM_LEFT("bl"),
    SQUARE_BOTTOM_RIGHT("br"),
    SQUARE_TOP_LEFT("tl"),
    SQUARE_TOP_RIGHT("tr"),
    STRIPE_BOTTOM("bs"),
    STRIPE_TOP("ts"),
    STRIPE_LEFT("ls"),
    STRIPE_RIGHT("rs"),
    STRIPE_CENTER("cs"),
    STRIPE_MIDDLE("ms"),
    STRIPE_DOWNRIGHT("drs"),
    STRIPE_DOWNLEFT("dls"),
    SMALL_STRIPES("ss"),
    CROSS("cr"),
    STRAIGHT_CROSS("sc"),
    TRIANGLE_BOTTOM("bt"),
    TRIANGLE_TOP("tt"),
    TRIANGLES_BOTTOM("bts"),
    TRIANGLES_TOP("tts"),
    DIAGONAL_LEFT("ld"),
    DIAGONAL_UP_RIGHT("rd"),
    DIAGONAL_UP_LEFT("lud"),
    DIAGONAL_RIGHT("rud"),
    CIRCLE("mc"),
    RHOMBUS("mr"),
    HALF_VERTICAL("vh"),
    HALF_HORIZONTAL("hh"),
    HALF_VERTICAL_RIGHT("vhr"),
    HALF_HORIZONTAL_BOTTOM("hhb"),
    BORDER("bo"),
    CURLY_BORDER("cbo"),
    GRADIENT("gra"),
    GRADIENT_UP("gru"),
    BRICKS("bri"),
    GLOBE("glb"),
    CREEPER("cre"),
    SKULL("sku"),
    FLOWER("flo"),
    MOJANG("moj"),
    PIGLIN("pig"),
    FLOW("flw"),
    GUSTER("gus");

    private static final BannerPattern[] VALUES;
    private final Key javaIdentifier = MinecraftKey.key(this.name().toLowerCase(Locale.ROOT));
    private final String bedrockIdentifier;

    private BannerPattern(String bedrockIdentifier) {
        this.bedrockIdentifier = bedrockIdentifier;
    }

    public static @Nullable BannerPattern getByJavaIdentifier(Key key) {
        for (BannerPattern bannerPattern : VALUES) {
            if (!bannerPattern.javaIdentifier.equals(key)) continue;
            return bannerPattern;
        }
        return null;
    }

    public static @Nullable BannerPattern getByBedrockIdentifier(String bedrockIdentifier) {
        for (BannerPattern bannerPattern : VALUES) {
            if (!bannerPattern.bedrockIdentifier.equals(bedrockIdentifier)) continue;
            return bannerPattern;
        }
        return null;
    }

    public Key getJavaIdentifier() {
        return this.javaIdentifier;
    }

    public String getBedrockIdentifier() {
        return this.bedrockIdentifier;
    }

    static {
        VALUES = BannerPattern.values();
    }
}

