/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal.tameable;

import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.animal.tameable.TameableEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.session.cache.tags.Tag;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;

public class ParrotEntity
extends TameableEntity {
    public ParrotEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    @Override
    protected @Nullable Tag<Item> getFoodTag() {
        return null;
    }

    private boolean isTameFood(Item item) {
        return this.session.getTagCache().is(ItemTag.PARROT_FOOD, item);
    }

    private boolean isPoisonousFood(Item item) {
        return this.session.getTagCache().is(ItemTag.PARROT_POISONOUS_FOOD, item);
    }

    @Override
    protected @NonNull InteractiveTag testMobInteraction(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        boolean tame = this.getFlag(EntityFlag.TAMED);
        if (!tame && this.isTameFood(itemInHand.asItem())) {
            return InteractiveTag.FEED;
        }
        if (this.isPoisonousFood(itemInHand.asItem())) {
            return InteractiveTag.FEED;
        }
        if (this.onGround && tame && this.ownerBedrockId == this.session.getPlayerEntity().getGeyserId()) {
            return this.getFlag(EntityFlag.SITTING) ? InteractiveTag.STAND : InteractiveTag.SIT;
        }
        return super.testMobInteraction(hand, itemInHand);
    }

    @Override
    protected @NonNull InteractionResult mobInteract(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        boolean tame = this.getFlag(EntityFlag.TAMED);
        if (!tame && this.isTameFood(itemInHand.asItem())) {
            return InteractionResult.SUCCESS;
        }
        if (this.isPoisonousFood(itemInHand.asItem())) {
            return InteractionResult.SUCCESS;
        }
        if (this.onGround && tame && this.ownerBedrockId == this.session.getPlayerEntity().getGeyserId()) {
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(hand, itemInHand);
    }
}

