/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal;

import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityEventType;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.packet.EntityEventPacket;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.animal.AnimalEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.session.cache.tags.Tag;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;

public class PandaEntity
extends AnimalEntity {
    private Gene mainGene = Gene.NORMAL;
    private Gene hiddenGene = Gene.NORMAL;

    public PandaEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    public void setEatingCounter(IntEntityMetadata entityMetadata) {
        int count = entityMetadata.getPrimitiveValue();
        this.setFlag(EntityFlag.EATING, count > 0);
        this.dirtyMetadata.put(EntityDataTypes.EATING_COUNTER, count);
        if (count != 0) {
            EntityEventPacket packet = new EntityEventPacket();
            packet.setRuntimeEntityId(this.geyserId);
            packet.setType(EntityEventType.EATING_ITEM);
            packet.setData(this.hand.getDefinition().getRuntimeId() << 16);
            this.session.sendUpstreamPacket(packet);
        }
    }

    public void setMainGene(ByteEntityMetadata entityMetadata) {
        this.mainGene = Gene.fromId(entityMetadata.getPrimitiveValue());
        this.updateAppearance();
    }

    public void setHiddenGene(ByteEntityMetadata entityMetadata) {
        this.hiddenGene = Gene.fromId(entityMetadata.getPrimitiveValue());
        this.updateAppearance();
    }

    public void setPandaFlags(ByteEntityMetadata entityMetadata) {
        byte xd = entityMetadata.getPrimitiveValue();
        this.setFlag(EntityFlag.SNEEZING, (xd & 2) == 2);
        this.setFlag(EntityFlag.ROLLING, (xd & 4) == 4);
        this.setFlag(EntityFlag.SITTING, (xd & 8) == 8);
        this.dirtyMetadata.put(EntityDataTypes.SITTING_AMOUNT, Float.valueOf((xd & 8) == 8 ? 1.0f : 0.0f));
        this.dirtyMetadata.put(EntityDataTypes.SITTING_AMOUNT_PREVIOUS, Float.valueOf((xd & 8) == 8 ? 1.0f : 0.0f));
        this.setFlag(EntityFlag.LAYING_DOWN, (xd & 0x10) == 16);
    }

    @Override
    protected @Nullable Tag<Item> getFoodTag() {
        return ItemTag.PANDA_FOOD;
    }

    @Override
    protected @NonNull InteractiveTag testMobInteraction(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (this.mainGene == Gene.WORRIED && this.session.isThunder()) {
            return InteractiveTag.NONE;
        }
        return super.testMobInteraction(hand, itemInHand);
    }

    @Override
    protected @NonNull InteractionResult mobInteract(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (this.mainGene == Gene.WORRIED && this.session.isThunder()) {
            return InteractionResult.PASS;
        }
        if (this.getFlag(EntityFlag.LAYING_DOWN)) {
            return InteractionResult.SUCCESS;
        }
        if (this.canEat(itemInHand)) {
            if (this.getFlag(EntityFlag.BABY)) {
                this.playEntityEvent(EntityEventType.BABY_ANIMAL_FEED);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean canBeLeashed() {
        return false;
    }

    private void updateAppearance() {
        if (this.mainGene.isRecessive) {
            if (this.mainGene == this.hiddenGene) {
                this.dirtyMetadata.put(EntityDataTypes.VARIANT, this.mainGene.ordinal());
            } else {
                this.dirtyMetadata.put(EntityDataTypes.VARIANT, Gene.NORMAL.ordinal());
            }
        } else {
            this.dirtyMetadata.put(EntityDataTypes.VARIANT, this.mainGene.ordinal());
        }
    }

    static enum Gene {
        NORMAL(false),
        LAZY(false),
        WORRIED(false),
        PLAYFUL(false),
        BROWN(true),
        WEAK(true),
        AGGRESSIVE(false);

        private static final Gene[] VALUES;
        private final boolean isRecessive;

        private Gene(boolean isRecessive) {
            this.isRecessive = isRecessive;
        }

        private static @Nullable Gene fromId(int id) {
            if (id < 0 || id >= VALUES.length) {
                return NORMAL;
            }
            return VALUES[id];
        }

        static {
            VALUES = Gene.values();
        }
    }
}

