/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.transformer;

import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.EnumSet;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodecHelper;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataMap;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.transformer.EntityDataTransformer;
import org.cloudburstmc.protocol.common.util.TypeMap;

public final class FlagTransformer
implements EntityDataTransformer<Long, EnumSet<EntityFlag>> {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(FlagTransformer.class);
    private final TypeMap<EntityFlag> typeMap;
    private final int index;

    @Override
    public Long serialize(BedrockCodecHelper helper, EntityDataMap map, EnumSet<EntityFlag> flags) {
        long value = 0L;
        int lower = this.index * 64;
        int upper = lower + 64;
        for (EntityFlag flag : flags) {
            int flagIndex = this.typeMap.getId(flag);
            if (flagIndex < lower || flagIndex >= upper) continue;
            value |= 1L << (flagIndex & 0x3F);
        }
        return value;
    }

    @Override
    public EnumSet<EntityFlag> deserialize(BedrockCodecHelper helper, EntityDataMap map, Long value) {
        EnumSet<EntityFlag> flags = map.getOrCreateFlags();
        int lower = this.index * 64;
        int upper = lower + 64;
        for (int i = lower; i < upper; ++i) {
            int idx = i & 0x3F;
            if ((value & 1L << idx) == 0L) continue;
            EntityFlag flag = this.typeMap.getType(i);
            if (flag != null) {
                flags.add(flag);
                continue;
            }
            log.debug("Unknown entity flag detected with index {}", (Object)i);
        }
        return flags;
    }

    public FlagTransformer(TypeMap<EntityFlag> typeMap, int index) {
        this.typeMap = typeMap;
        this.index = index;
    }
}

