/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.math.immutable.vector;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.cloudburstmc.math.vector.Vector2l;

@ParametersAreNonnullByDefault
@Immutable
public class ImmutableVector2l
extends Vector2l {
    private static final long serialVersionUID = 1L;
    private final long x;
    private final long y;
    private volatile transient boolean hashed = false;
    private volatile transient int hashCode = 0;

    ImmutableVector2l(long x, long y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public long getX() {
        return this.x;
    }

    @Override
    public long getY() {
        return this.y;
    }

    @Override
    @Nonnull
    public Vector2l add(long x, long y) {
        return Vector2l.from(this.x + x, this.y + y);
    }

    @Override
    @Nonnull
    public Vector2l sub(long x, long y) {
        return Vector2l.from(this.x - x, this.y - y);
    }

    @Override
    @Nonnull
    public Vector2l mul(long x, long y) {
        return Vector2l.from(this.x * x, this.y * y);
    }

    @Override
    @Nonnull
    public Vector2l div(long x, long y) {
        return Vector2l.from(this.x / x, this.y / y);
    }

    @Override
    @Nonnull
    public Vector2l project(long x, long y) {
        long lengthSquared = x * x + y * y;
        if (lengthSquared == 0L) {
            throw new ArithmeticException("Cannot project onto the zero vector");
        }
        double a = (double)this.dot(x, y) / (double)lengthSquared;
        return Vector2l.from(a * (double)x, a * (double)y);
    }

    @Override
    @Nonnull
    public Vector2l pow(long power) {
        return Vector2l.from(Math.pow(this.x, power), Math.pow(this.y, power));
    }

    @Override
    @Nonnull
    public Vector2l abs() {
        return Vector2l.from(Math.abs(this.x), Math.abs(this.y));
    }

    @Override
    @Nonnull
    public Vector2l negate() {
        return Vector2l.from(-this.x, -this.y);
    }

    @Override
    @Nonnull
    public Vector2l min(long x, long y) {
        return Vector2l.from(Math.min(this.x, x), Math.min(this.y, y));
    }

    @Override
    @Nonnull
    public Vector2l max(long x, long y) {
        return Vector2l.from(Math.max(this.x, x), Math.max(this.y, y));
    }

    @Override
    @Nonnull
    public Vector2l north(long v) {
        return Vector2l.from(this.x, this.y - v);
    }

    @Override
    @Nonnull
    public Vector2l south(long v) {
        return Vector2l.from(this.x, this.y + v);
    }

    @Override
    @Nonnull
    public Vector2l east(long v) {
        return Vector2l.from(this.x + v, this.y);
    }

    @Override
    @Nonnull
    public Vector2l west(long v) {
        return Vector2l.from(this.x - v, this.y);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Vector2l)) {
            return false;
        }
        Vector2l vector2 = (Vector2l)o;
        if (vector2.getX() != this.x) {
            return false;
        }
        return vector2.getY() == this.y;
    }

    public int hashCode() {
        if (!this.hashed) {
            int result = (float)this.x != 0.0f ? Long.hashCode(this.x) : 0;
            this.hashCode = 31 * result + ((float)this.y != 0.0f ? Long.hashCode(this.y) : 0);
            this.hashed = true;
        }
        return this.hashCode;
    }
}

