/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.math.immutable.vector;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.vector.Vector2f;

@ParametersAreNonnullByDefault
@Immutable
public class ImmutableVector2f
extends Vector2f {
    private static final long serialVersionUID = 1L;
    private final float x;
    private final float y;
    private volatile transient boolean hashed = false;
    private volatile transient int hashCode = 0;

    ImmutableVector2f(float x, float y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    @Nonnull
    public Vector2f add(float x, float y) {
        return Vector2f.from(this.getX() + x, this.getY() + y);
    }

    @Override
    @Nonnull
    public Vector2f sub(float x, float y) {
        return Vector2f.from(this.getX() - x, this.getY() - y);
    }

    @Override
    @Nonnull
    public Vector2f mul(float x, float y) {
        return Vector2f.from(this.getX() * x, this.getY() * y);
    }

    @Override
    @Nonnull
    public Vector2f div(float x, float y) {
        return Vector2f.from(this.getX() / x, this.getY() / y);
    }

    @Override
    @Nonnull
    public Vector2f project(float x, float y) {
        float lengthSquared = x * x + y * y;
        if (Math.abs(lengthSquared) < GenericMath.FLT_EPSILON) {
            throw new ArithmeticException("Cannot project onto the zero vector");
        }
        float a = this.dot(x, y) / lengthSquared;
        return Vector2f.from(a * x, a * y);
    }

    @Override
    @Nonnull
    public Vector2f pow(float power) {
        return Vector2f.from(Math.pow(this.getX(), power), Math.pow(this.getY(), power));
    }

    @Override
    @Nonnull
    public Vector2f ceil() {
        return Vector2f.from(Math.ceil(this.getX()), Math.ceil(this.getY()));
    }

    @Override
    @Nonnull
    public Vector2f floor() {
        return Vector2f.from(GenericMath.floor(this.getX()), GenericMath.floor(this.getY()));
    }

    @Override
    @Nonnull
    public Vector2f round() {
        return Vector2f.from(Math.round(this.getX()), Math.round(this.getY()));
    }

    @Override
    @Nonnull
    public Vector2f abs() {
        return Vector2f.from(Math.abs(this.getX()), Math.abs(this.getY()));
    }

    @Override
    @Nonnull
    public Vector2f negate() {
        return Vector2f.from(-this.getX(), -this.getY());
    }

    @Override
    @Nonnull
    public Vector2f min(float x, float y) {
        return Vector2f.from(Math.min(this.getX(), x), Math.min(this.getY(), y));
    }

    @Override
    @Nonnull
    public Vector2f max(float x, float y) {
        return Vector2f.from(Math.max(this.getX(), x), Math.max(this.getY(), y));
    }

    @Override
    @Nonnull
    public Vector2f north(float v) {
        return Vector2f.from(this.getX(), this.getY() - v);
    }

    @Override
    @Nonnull
    public Vector2f south(float v) {
        return Vector2f.from(this.getX(), this.getY() + v);
    }

    @Override
    @Nonnull
    public Vector2f east(float v) {
        return Vector2f.from(this.getX() + v, this.getY());
    }

    @Override
    @Nonnull
    public Vector2f west(float v) {
        return Vector2f.from(this.getX() - v, this.getY());
    }

    @Override
    @Nonnull
    public Vector2f normalize() {
        float length = this.length();
        if (Math.abs(length) < GenericMath.FLT_EPSILON) {
            throw new ArithmeticException("Cannot normalize the zero vector");
        }
        return Vector2f.from(this.getX() / length, this.getY() / length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Vector2f)) {
            return false;
        }
        Vector2f vector2 = (Vector2f)o;
        if (Float.compare(vector2.getX(), this.x) != 0) {
            return false;
        }
        return Float.compare(vector2.getY(), this.y) == 0;
    }

    public int hashCode() {
        if (!this.hashed) {
            int result = this.x != 0.0f ? Float.hashCode(this.x) : 0;
            this.hashCode = 31 * result + (this.y != 0.0f ? Float.hashCode(this.y) : 0);
            this.hashed = true;
        }
        return this.hashCode;
    }
}

