/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.math.immutable.vector;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.vector.Vector2d;

@ParametersAreNonnullByDefault
@Immutable
public class ImmutableVector2d
extends Vector2d {
    private static final long serialVersionUID = 1L;
    private final double x;
    private final double y;
    private volatile transient boolean hashed = false;
    private volatile transient int hashCode = 0;

    ImmutableVector2d(double x, double y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    @Nonnull
    public Vector2d add(double x, double y) {
        return Vector2d.from(this.getX() + x, this.getY() + y);
    }

    @Override
    @Nonnull
    public Vector2d sub(double x, double y) {
        return Vector2d.from(this.getX() - x, this.getY() - y);
    }

    @Override
    @Nonnull
    public Vector2d mul(double x, double y) {
        return Vector2d.from(this.getX() * x, this.getY() * y);
    }

    @Override
    @Nonnull
    public Vector2d div(double x, double y) {
        return Vector2d.from(this.getX() / x, this.getY() / y);
    }

    @Override
    @Nonnull
    public Vector2d project(double x, double y) {
        double lengthSquared = x * x + y * y;
        if (Math.abs(lengthSquared) < GenericMath.DBL_EPSILON) {
            throw new ArithmeticException("Cannot project onto the zero vector");
        }
        double a = this.dot(x, y) / lengthSquared;
        return Vector2d.from(a * x, a * y);
    }

    @Override
    @Nonnull
    public Vector2d pow(double power) {
        return Vector2d.from(Math.pow(this.getX(), power), Math.pow(this.getY(), power));
    }

    @Override
    @Nonnull
    public Vector2d ceil() {
        return Vector2d.from(Math.ceil(this.getX()), Math.ceil(this.getY()));
    }

    @Override
    @Nonnull
    public Vector2d floor() {
        return Vector2d.from(GenericMath.floor(this.getX()), GenericMath.floor(this.getY()));
    }

    @Override
    @Nonnull
    public Vector2d round() {
        return Vector2d.from(Math.round(this.getX()), Math.round(this.getY()));
    }

    @Override
    @Nonnull
    public Vector2d abs() {
        return Vector2d.from(Math.abs(this.getX()), Math.abs(this.getY()));
    }

    @Override
    @Nonnull
    public Vector2d negate() {
        return Vector2d.from(-this.getX(), -this.getY());
    }

    @Override
    @Nonnull
    public Vector2d min(double x, double y) {
        return Vector2d.from(Math.min(this.getX(), x), Math.min(this.getY(), y));
    }

    @Override
    @Nonnull
    public Vector2d max(double x, double y) {
        return Vector2d.from(Math.max(this.getX(), x), Math.max(this.getY(), y));
    }

    @Override
    @Nonnull
    public Vector2d north(double v) {
        return Vector2d.from(this.getX(), this.getY() - v);
    }

    @Override
    @Nonnull
    public Vector2d south(double v) {
        return Vector2d.from(this.getX(), this.getY() + v);
    }

    @Override
    @Nonnull
    public Vector2d east(double v) {
        return Vector2d.from(this.getX() + v, this.getY());
    }

    @Override
    @Nonnull
    public Vector2d west(double v) {
        return Vector2d.from(this.getX() - v, this.getY());
    }

    @Override
    @Nonnull
    public Vector2d normalize() {
        double length = this.length();
        if (Math.abs(length) < GenericMath.DBL_EPSILON) {
            throw new ArithmeticException("Cannot normalize the zero vector");
        }
        return Vector2d.from(this.getX() / length, this.getY() / length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Vector2d)) {
            return false;
        }
        Vector2d vector2 = (Vector2d)o;
        if (Double.compare(vector2.getX(), this.x) != 0) {
            return false;
        }
        return Double.compare(vector2.getY(), this.y) == 0;
    }

    public int hashCode() {
        if (!this.hashed) {
            int result = this.x != 0.0 ? Double.hashCode(this.x) : 0;
            this.hashCode = 31 * result + (this.y != 0.0 ? Double.hashCode(this.y) : 0);
            this.hashed = true;
        }
        return this.hashCode;
    }
}

