/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.math.imaginary;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.TrigMath;
import org.cloudburstmc.math.imaginary.Complexd;
import org.cloudburstmc.math.imaginary.Imaginary;
import org.cloudburstmc.math.imaginary.Imaginaryf;
import org.cloudburstmc.math.imaginary.Quaternionf;
import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.math.vector.Vector3f;

@ParametersAreNonnullByDefault
public abstract class Complexf
implements Imaginaryf,
Comparable<Complexf>,
Serializable,
Cloneable {
    public static final Complexf ZERO = Complexf.from(0.0f, 0.0f);
    public static final Complexf IDENTITY = Complexf.from(1.0f, 0.0f);

    public abstract float getX();

    public abstract float getY();

    @Nonnull
    public Complexf add(Complexf c) {
        return this.add(c.getX(), c.getY());
    }

    @Nonnull
    public Complexf add(double x, double y) {
        return this.add((float)x, (float)y);
    }

    @Nonnull
    public abstract Complexf add(float var1, float var2);

    @Nonnull
    public Complexf sub(Complexf c) {
        return this.sub(c.getX(), c.getY());
    }

    @Nonnull
    public Complexf sub(double x, double y) {
        return this.sub((float)x, (float)y);
    }

    @Nonnull
    public abstract Complexf sub(float var1, float var2);

    @Nonnull
    public Complexf mul(double a) {
        return this.mul((float)a);
    }

    @Override
    @Nonnull
    public abstract Complexf mul(float var1);

    @Nonnull
    public Complexf mul(Complexf c) {
        return this.mul(c.getX(), c.getY());
    }

    @Nonnull
    public Complexf mul(double x, double y) {
        return this.mul((float)x, (float)y);
    }

    @Nonnull
    public abstract Complexf mul(float var1, float var2);

    @Nonnull
    public Complexf div(double a) {
        return this.div((float)a);
    }

    @Override
    @Nonnull
    public abstract Complexf div(float var1);

    @Nonnull
    public Complexf div(Complexf c) {
        return this.div(c.getX(), c.getY());
    }

    @Nonnull
    public Complexf div(double x, double y) {
        return this.div((float)x, (float)y);
    }

    @Nonnull
    public abstract Complexf div(float var1, float var2);

    public float dot(Complexf c) {
        return this.dot(c.getX(), c.getY());
    }

    public float dot(double x, double y) {
        return this.dot((float)x, (float)y);
    }

    public float dot(float x, float y) {
        return this.getX() * x + this.getY() * y;
    }

    @Nonnull
    public Vector2f rotate(Vector2f v) {
        return this.rotate(v.getX(), v.getY());
    }

    @Nonnull
    public Vector2f rotate(double x, double y) {
        return this.rotate((float)x, (float)y);
    }

    @Nonnull
    public Vector2f rotate(float x, float y) {
        float length = this.length();
        if (Math.abs(length) < GenericMath.FLT_EPSILON) {
            throw new ArithmeticException("Cannot rotate by the zero complex");
        }
        float nx = this.getX() / length;
        float ny = this.getY() / length;
        return Vector2f.from(x * nx - y * ny, y * nx + x * ny);
    }

    @Nonnull
    public Vector2f getDirection() {
        return Vector2f.from(this.getX(), this.getY()).normalize();
    }

    public float getAngleRad() {
        return (float)TrigMath.atan2(this.getY(), this.getX());
    }

    public float getAngleDeg() {
        return (float)Math.toDegrees(this.getAngleRad());
    }

    @Override
    @Nonnull
    public abstract Complexf conjugate();

    @Override
    @Nonnull
    public abstract Complexf invert();

    @Override
    public float lengthSquared() {
        return this.getX() * this.getX() + this.getY() * this.getY();
    }

    @Override
    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    @Override
    @Nonnull
    public abstract Complexf normalize();

    @Nonnull
    public Quaternionf toQuaternion() {
        return this.toQuaternion(Vector3f.UNIT_Z);
    }

    @Nonnull
    public Quaternionf toQuaternion(Vector3f axis) {
        return this.toQuaternion(axis.getX(), axis.getY(), axis.getZ());
    }

    @Nonnull
    public Quaternionf toQuaternion(double x, double y, double z) {
        return this.toQuaternion((float)x, (float)y, (float)z);
    }

    @Nonnull
    public Quaternionf toQuaternion(float x, float y, float z) {
        return Quaternionf.fromAngleRadAxis(this.getAngleRad(), x, y, z);
    }

    @Override
    @Nonnull
    public Complexf toFloat() {
        return Complexf.from(this.getX(), this.getY());
    }

    @Override
    @Nonnull
    public Complexd toDouble() {
        return Complexd.from(this.getX(), this.getY());
    }

    @Override
    public int compareTo(Complexf c) {
        return (int)Math.signum(this.lengthSquared() - c.lengthSquared());
    }

    @Nonnull
    public Complexf clone() {
        return Complexf.from(this);
    }

    @Nonnull
    public String toString() {
        return "(" + this.getX() + ", " + this.getY() + ")";
    }

    @Nonnull
    public static Complexf fromReal(float x) {
        return Imaginary.createComplexf(x, 0.0f);
    }

    @Nonnull
    public static Complexf fromImaginary(float y) {
        return Imaginary.createComplexf(0.0f, y);
    }

    @Nonnull
    public static Complexf from(Complexf c) {
        return Complexf.from(c.getX(), c.getY());
    }

    @Nonnull
    public static Complexf from(double x, double y) {
        return Complexf.from((float)x, (float)y);
    }

    @Nonnull
    public static Complexf from(float x, float y) {
        return Imaginary.createComplexf(x, y);
    }

    @Nonnull
    public static Complexf fromRotationTo(Vector2f from, Vector2f to) {
        return Complexf.fromAngleRad(TrigMath.acos(from.dot(to) / (from.length() * to.length())));
    }

    @Nonnull
    public static Complexf fromRotationTo(Vector3f from, Vector3f to) {
        return Complexf.fromAngleRad(TrigMath.acos(from.dot(to) / (from.length() * to.length())));
    }

    @Nonnull
    public static Complexf fromAngleDeg(double angle) {
        return Complexf.fromAngleRad(Math.toRadians(angle));
    }

    @Nonnull
    public static Complexf fromAngleRad(double angle) {
        return Complexf.fromAngleRad((float)angle);
    }

    @Nonnull
    public static Complexf fromAngleDeg(float angle) {
        return Complexf.fromAngleRad((float)Math.toRadians(angle));
    }

    @Nonnull
    public static Complexf fromAngleRad(float angle) {
        return Complexf.from(TrigMath.cos(angle), TrigMath.sin(angle));
    }
}

